////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/OrchestrationException.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * <p>The {@link ActivationInputException} exception is raised during activation-specific flows. Possible error codes are defined in OrchestrationErrorCodes.h</p>
 */
@interface ActivationInputException : OrchestrationException

/** error code attached to the error */
@property (nonatomic, readonly) int errorCode;

/**
 * Constructor
 * @param message message describing the exception
 * @param errorCode error code (see OrchestrationErrorCodes.h)
 */
- (id)initWithMessage:(NSString *)message errorCode:(int)errorCode;

@end

NS_ASSUME_NONNULL_END
